/*
 * Decompiled with CFR 0.152.
 */
package net.sabicorp.bootstrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class Bootstrapper {
    private static final String VERSION_URL = "https://mcupdater.sabicorp.net/bootstrapper/latest-version.txt";
    private static final String DOWNLOAD_BASE_URL = "https://mcupdater.sabicorp.net/self/";

    public static void main(String[] args) throws Exception {
        String updaterFileName;
        File updaterJar;
        System.out.println("=== SABICORP Bootstrapper ===");
        String modpackId = Bootstrapper.getArg(args, "--modpackid=");
        if (modpackId == null) {
            System.err.println("[ERROR] Falta el par\u00e1metro --modpackid=");
            System.exit(1);
        }
        String env = Bootstrapper.getArg(args, "--env=");
        String version = Bootstrapper.readVersionFromRemote();
        if (version == null || version.isBlank()) {
            System.err.println("[ERROR] No se pudo obtener la versi\u00f3n desde el servidor.");
            System.exit(1);
        }
        if (!(updaterJar = new File(updaterFileName = "sabicorp-mods-updater-" + version + ".jar")).exists()) {
            System.out.println("[DOWNLOAD] Descargando updater versi\u00f3n " + version + "...");
            String url = DOWNLOAD_BASE_URL + updaterFileName;
            try (InputStream in = new URL(url).openStream();){
                Files.copy(in, updaterJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.out.println("[OK] Descargado: " + updaterFileName);
            }
            catch (IOException e) {
                System.err.println("[ERROR] Error descargando el updater: " + e.getMessage());
                System.exit(1);
            }
        }
        Bootstrapper.cleanupOldUpdaterJars(version);
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-jar");
        command.add(updaterJar.getName());
        command.add("--modpackid=" + modpackId);
        if (env != null) {
            command.add("--env=" + env);
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.inheritIO();
        Process process = pb.start();
        int exitCode = process.waitFor();
        System.exit(exitCode);
    }

    private static String getArg(String[] args, String key) {
        for (String arg : args) {
            if (!arg.startsWith(key)) continue;
            return arg.substring(key.length());
        }
        return null;
    }

    private static String readVersionFromRemote() {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(VERSION_URL).openStream()));
        try {
            string = reader.readLine().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("[ERROR] Error leyendo versi\u00f3n remota: " + e.getMessage());
                return null;
            }
        }
        reader.close();
        return string;
    }

    private static void cleanupOldUpdaterJars(String keepVersion) {
        File dir = new File(".");
        File[] jars = dir.listFiles((d, name) -> name.startsWith("sabicorp-mods-updater-") && name.endsWith(".jar") && !name.contains(keepVersion));
        if (jars == null) {
            return;
        }
        for (File jar : jars) {
            System.out.println("[DELETE] Eliminando versi\u00f3n antigua: " + jar.getName());
            jar.delete();
        }
    }
}

